unit UnitFormMain;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.ExtCtrls, Vcl.Samples.Spin,
  Vcl.StdCtrls, UnitFormFromDll, Vcl.ComCtrls, Vcl.Buttons, System.IniFiles;

type
  TFormMain = class(TForm)
    MemoDebug: TMemo;
    Label1: TLabel;
    GroupBox1: TGroupBox;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    SpinEdit1: TSpinEdit;
    SpinEdit2: TSpinEdit;
    LEText: TLabeledEdit;
    LETestImageFN: TLabeledEdit;
    LETestSoundFN: TLabeledEdit;
    LETestMovieFN: TLabeledEdit;
    LEMyScript: TLabeledEdit;
    SEAnswersType: TSpinEdit;
    SEWeightTest: TSpinEdit;
    SESecondsTO: TSpinEdit;
    Button1: TButton;
    GroupBox2: TGroupBox;
    Label7: TLabel;
    SEiCurSecForTO: TSpinEdit;
    DTPStartLesson: TDateTimePicker;
    OpenDialogDLL: TOpenDialog;
    LEFN: TLabeledEdit;
    SpeedButton1: TSpeedButton;
    BFormFromDLL: TButton;
    CBmyLessonType: TComboBox;
    Label8: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure MemoDebugDblClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure BFormFromDLLClick(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
    procedure LoadMyParam(fn: TFileName);
    procedure SaveMyParam(fn: TFileName);
  public
    { Public declarations }
    dllPrepareAndShowModal: function(rpch: TRecTestPChar): integer;  stdcall;
    dllPrepareStartT: function(sr: TMyStartRecord):integer; stdcall;
    dllDestroyMyDLGForm: function: Integer; stdcall;

    dllGetMyScriptForReturn: function: PChar; stdcall;
    dllGetMyReturnIntValue1: function: integer; stdcall;
    dllGetMyReturnIntValue2: function: integer; stdcall;
    dllGetMyEntAnswer: function: PChar; stdcall;
    dllGetMyCorrectAnswer: function: PChar; stdcall;
    dllGetMyQuestion: function : PChar; stdcall;
    dllGetMyResult: function : integer; stdcall;

    LibHandle: THandle;
  end;

var
  FormMain: TFormMain;

  fnMyDLLFN: TFileName;
implementation

{$R *.dfm}

procedure TFormMain.Button1Click(Sender: TObject);
var r: TRecTest; rpch: TRecTestPChar;  sss: string;   mmodres: TModalResult;
    sr: TMyStartRecord;
    wy, wm, wd, wh, wmin, ws, wms: word;
begin
        r.ID := SpinEdit1.Value;
        r.MyTestType := SpinEdit2.Value;
        r.Text := LEText.Text;  //' Text   ';
        r.TestImageFN := LETestImageFN.Text; //' TestImageFN   ';
        r.TestSoundFN := LETestSoundFN.Text;//' TestSoundFN   ';
        r.TestMovieFN := LETestMovieFN.Text;//' TestMovieFN   ';
        r.AnswersType := SEAnswersType.Value;
        r.WeightTest := SEWeightTest.Value;
        r.SecondsTO := SESecondsTO.Value;
        r.MyScript := LEMyScript.Text;//' MyScript   ';

        TRecTestToTRecTestPChar(r, rpch);

         //PrepareAndShowModal(mpwc, mcfn, rpch);
         DTPStartLesson.DateTime := Now;
         DecodeDate(DTPStartLesson.DateTime, wy, wm, wd);
         DecodeTime(DTPStartLesson.DateTime, wh, wmin, ws, wms);
         sr.iCurSecForTO := SEiCurSecForTO.Value;
         sr.myLessonType := CBmyLessonType.ItemIndex;
         sr.idtSLYear := wy;
         sr.idtSLMonth := wm;
         sr.idtSLDay := wd;
         sr.idtSLHour := wh;
         sr.idtSLMin := wmin;
         sr.idtSLSec := ws;
         sr.idtSLmSec := wms;

         PrepareStartT(sr);

         mmodres := PrepareAndShowModal(rpch);

         case mmodres of
           mrOK: sss := 'OK - ""';
           mrCancel: sss := 'Cancel - " "';
           mrIgnore: sss := 'Ignore - "  "';
         end;//case mmodres of
         MemoDebug.Lines.Add(sss);

         MemoDebug.Lines.Add('GetMyQuestion:');
         sss := StrPas(GetMyQuestion);
         MemoDebug.Lines.Add(sss);

         MemoDebug.Lines.Add('GetMyScriptForReturn:');
         sss := StrPas(GetMyScriptForReturn);
         MemoDebug.Lines.Add(sss);

         MemoDebug.Lines.Add('GetMyReturnIntValue1:');
         sss := IntToStr(GetMyReturnIntValue1);
         MemoDebug.Lines.Add(sss);

         MemoDebug.Lines.Add('GetMyReturnIntValue2:');
         sss := IntToStr(GetMyReturnIntValue2);
         MemoDebug.Lines.Add(sss);

         MemoDebug.Lines.Add('GetMyEntAnswer:');
         sss := StrPas(GetMyEntAnswer);
         MemoDebug.Lines.Add(sss);

         MemoDebug.Lines.Add('GetMyCorrectAnswer:');
         sss := StrPas(GetMyCorrectAnswer);
         MemoDebug.Lines.Add(sss);

         MemoDebug.Lines.Add('GetMyResult:');
         sss := IntToStr(GetMyResult);
         MemoDebug.Lines.Add(sss);

         MemoDebug.Lines.Add('-------------------------');

         DestroyMyDLGForm;
end;

procedure TFormMain.BFormFromDLLClick(Sender: TObject);
var r: TRecTest; rpch: TRecTestPChar;  sss: string;   mmodres: TModalResult;
    sr: TMyStartRecord;
    wy, wm, wd, wh, wmin, ws, wms: word;
begin
        r.ID := SpinEdit1.Value;
        r.MyTestType := SpinEdit2.Value;
        r.Text := LEText.Text;  //' Text   ';
        r.TestImageFN := LETestImageFN.Text; //' TestImageFN   ';
        r.TestSoundFN := LETestSoundFN.Text;//' TestSoundFN   ';
        r.TestMovieFN := LETestMovieFN.Text;//' TestMovieFN   ';
        r.AnswersType := SEAnswersType.Value;
        r.WeightTest := SEWeightTest.Value;
        r.SecondsTO := SESecondsTO.Value;
        r.MyScript := LEMyScript.Text;//' MyScript   ';

        TRecTestToTRecTestPChar(r, rpch);

         //PrepareAndShowModal(mpwc, mcfn, rpch);
         DTPStartLesson.DateTime := Now;
         DecodeDate(DTPStartLesson.DateTime, wy, wm, wd);
         DecodeTime(DTPStartLesson.DateTime, wh, wmin, ws, wms);
         sr.iCurSecForTO := SEiCurSecForTO.Value;
         sr.myLessonType := CBmyLessonType.ItemIndex;
         sr.idtSLYear := wy;
         sr.idtSLMonth := wm;
         sr.idtSLDay := wd;
         sr.idtSLHour := wh;
         sr.idtSLMin := wmin;
         sr.idtSLSec := ws;
         sr.idtSLmSec := wms;

  if FileExists(fnMyDLLFN) then
   begin
     //@PrepareAndShowModal := nil;
     LibHandle := LoadLibrary(PWideChar(fnMyDLLFN));
     if LibHandle >= 32 then
       begin
        // @GetSimpleText := GetProcAddress(LibHandle,'GetSimpleText');
        @dllPrepareAndShowModal := GetProcAddress(LibHandle, 'PrepareAndShowModal');
        @dllPrepareStartT := GetProcAddress(LibHandle, 'PrepareStartT');
        @dllDestroyMyDLGForm := GetProcAddress(LibHandle, 'DestroyMyDLGForm');
        @dllGetMyScriptForReturn := GetProcAddress(LibHandle, 'GetMyScriptForReturn');
        @dllGetMyReturnIntValue1 := GetProcAddress(LibHandle, 'GetMyReturnIntValue1');
        @dllGetMyReturnIntValue2 := GetProcAddress(LibHandle, 'GetMyReturnIntValue2');
        @dllGetMyEntAnswer := GetProcAddress(LibHandle, 'GetMyEntAnswer');
        @dllGetMyCorrectAnswer := GetProcAddress(LibHandle, 'GetMyCorrectAnswer');
        @dllGetMyQuestion := GetProcAddress(LibHandle, 'GetMyQuestion');
        @dllGetMyResult := GetProcAddress(LibHandle, 'GetMyResult');;


        dllPrepareStartT(sr);
        mmodres := dllPrepareAndShowModal(rpch);

        case mmodres of
           mrOK: sss := 'OK - ""';
           mrCancel: sss := 'Cancel - " "';
           mrIgnore: sss := 'Ignore - "  "';
         end;//case mmodres of
         MemoDebug.Lines.Add(sss);

         MemoDebug.Lines.Add('GetMyQuestion:');
         sss := StrPas(dllGetMyQuestion);
         MemoDebug.Lines.Add(sss);

         MemoDebug.Lines.Add('GetMyScriptForReturn:');
         sss := StrPas(dllGetMyScriptForReturn);
         MemoDebug.Lines.Add(sss);

         MemoDebug.Lines.Add('GetMyReturnIntValue1:');
         sss := IntToStr(dllGetMyReturnIntValue1);
         MemoDebug.Lines.Add(sss);

         MemoDebug.Lines.Add('GetMyReturnIntValue2:');
         sss := IntToStr(dllGetMyReturnIntValue2);
         MemoDebug.Lines.Add(sss);

         MemoDebug.Lines.Add('GetMyEntAnswer:');
         sss := StrPas(dllGetMyEntAnswer);
         MemoDebug.Lines.Add(sss);

         MemoDebug.Lines.Add('GetMyCorrectAnswer:');
         sss := StrPas(dllGetMyCorrectAnswer);
         MemoDebug.Lines.Add(sss);

         MemoDebug.Lines.Add('GetMyResult:');
         sss := IntToStr(dllGetMyResult);
         MemoDebug.Lines.Add(sss);

         MemoDebug.Lines.Add('-------------------------');


        dllDestroyMyDLGForm;
       end;//if LibHandle >= 32 then

     FreeLibrary(LibHandle);
   end;//if FileExists(fnMyDLLFN) then
end;

procedure TFormMain.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   SaveMyParam(ChangeFileExt(Application.ExeName, '.ini'));
end;

procedure TFormMain.FormCreate(Sender: TObject);
begin
 DTPStartLesson.DateTime := Now;
 LoadMyParam(ChangeFileExt(Application.ExeName, '.ini'));
 LEFN.Text := fnMyDLLFN;
end;

procedure TFormMain.LoadMyParam(fn: TFileName);
var  MyIniFile: TIniFile;
begin
 try
   if FileExists(fn) then
    begin
       MyIniFile:=TIniFile.Create(fn);
       fnMyDLLFN  := MyIniFile.ReadString('fnMyDLLFN','fnMyDLLFN', '');

       SpinEdit1.Value :=  MyIniFile.ReadInteger('SpinEdit1', 'Value', 0);
       SpinEdit2.Value :=  MyIniFile.ReadInteger('SpinEdit2', 'Value', 0);

       LEText.Text :=  MyIniFile.ReadString('LEText', 'Text', '');
       LETestImageFN.Text :=  MyIniFile.ReadString('LETestImageFN', 'Text', '');
       LETestSoundFN.Text :=  MyIniFile.ReadString('LETestSoundFN', 'Text', '');
       LETestMovieFN.Text :=  MyIniFile.ReadString('LETestMovieFN', 'Text', '');

       SEAnswersType.Value :=  MyIniFile.ReadInteger('SEAnswersType', 'Value', 0);
       SEWeightTest.Value :=  MyIniFile.ReadInteger('SEWeightTest', 'Value', 0);
       SESecondsTO.Value :=  MyIniFile.ReadInteger('SESecondsTO', 'Value', 0);

       LEMyScript.Text :=  MyIniFile.ReadString('LEMyScript', 'Text', '');
       SEiCurSecForTO.Value :=  MyIniFile.ReadInteger('SEiCurSecForTO', 'Value', 0);

       //.Value :=  MyIniFile.ReadInteger('', 'Value', 0)
       //.Text :=  MyIniFile.ReadString('', 'Text', '');

       MyIniFile.Free;
    end;
 except
     ShowMessage(' LoadMyParam('+fn
      +').    '+ExtractFilePath(fn));
 end;
end;

procedure TFormMain.MemoDebugDblClick(Sender: TObject);
begin
  MemoDebug.Clear;
end;

procedure TFormMain.SaveMyParam(fn: TFileName);
var  MyIniFile: TIniFile;
begin
  try
   if FileExists(fn) then DeleteFile(fn);
   MyIniFile:=TIniFile.Create(fn);

   MyIniFile.WriteString('fnMyDLLFN','fnMyDLLFN', fnMyDLLFN);

   MyIniFile.WriteInteger('SpinEdit1', 'Value', SpinEdit1.Value);
   MyIniFile.WriteInteger('SpinEdit2', 'Value', SpinEdit2.Value);

   MyIniFile.WriteString('LEText', 'Text', LEText.Text);
   MyIniFile.WriteString('LETestImageFN', 'Text', LETestImageFN.Text);
   MyIniFile.WriteString('LETestSoundFN', 'Text', LETestSoundFN.Text);
   MyIniFile.WriteString('LETestMovieFN', 'Text', LETestMovieFN.Text);

   MyIniFile.WriteInteger('SEAnswersType', 'Value', SEAnswersType.Value);
   MyIniFile.WriteInteger('SEWeightTest', 'Value', SEWeightTest.Value);
   MyIniFile.WriteInteger('SESecondsTO', 'Value', SESecondsTO.Value);

   MyIniFile.WriteString('LEMyScript', 'Text', LEMyScript.Text);

   MyIniFile.WriteInteger('SEiCurSecForTO', 'Value', SEiCurSecForTO.Value);

   //MyIniFile.WriteInteger('', 'Value', .Value);
   //MyIniFile.WriteString('', 'Text', .Text);

   MyIniFile.Free;
 except
   ShowMessage(' SaveMyParam('+fn
      +').    '+ExtractFilePath(fn));
 end;
end;

procedure TFormMain.SpeedButton1Click(Sender: TObject);
begin
  if OpenDialogDLL.Execute then
    begin
     fnMyDLLFN := OpenDialogDLL.FileName;
     LEFN.Text := fnMyDLLFN;
    end;//if OpenDialogDLL.Execute then
end;

end.
